package com.vf106.tools.activity;

import android.content.Intent;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;

import java.io.File;
import java.io.IOException;

public class AudioRecordingActivity extends BaseActivity implements View.OnClickListener {
    private static final String LOG_TAG = "MainActivity";
    //Voice file save path
    private String FileName = null;
    private Button startRecord;
    private Button startPlay;

    //voice-activated objects
    private MediaPlayer mPlayer = null;
    private MediaRecorder mRecorder = null;

    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    private boolean startRecordFlag = false;
    private boolean startPlayRecordFlag = false;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_audio_recording);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);

        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);

        //Start recording
        startRecord = findViewById(R.id.startRecord);
        //start playing
        startPlay = findViewById(R.id.startPlay);

        //Setting the path to the sdcard
//        FileName = Environment.getExternalStorageDirectory().getAbsolutePath();
//        FileName += "/test.mp3";

        File externalFilesDir = getExternalFilesDir(null);
        if (externalFilesDir != null) {
            String sandboxPath = externalFilesDir.getAbsolutePath();
            // Now you can splice the file paths into this directory
            FileName = sandboxPath + "/test.mp3";

            Log.i("Path to the recording", FileName);
            // The filePath is now the path to the file you want.
        } else {
            // External storage not available
        }

    }

    @Override
    protected void setTitle() {

    }

    @Override
    protected void setListener() {
        startRecord.setOnClickListener(new startRecordListener());
        startPlay.setOnClickListener(new startPlayListener());

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    //sound recordings
    class startRecordListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            if (!startRecordFlag) {
                startRecordFlag = true;
                startRecord.setText("Pause recording");
                startPlay.setVisibility(View.GONE);
                startRecord();
            } else {
                startRecordFlag = false;
                startRecord.setText("Start recording");
                startPlay.setVisibility(View.VISIBLE);
                stopRecord();
            }
        }

    }

    //Stop recording
    public void stopRecord() {
        mRecorder.stop();
        mRecorder.release();
        mRecorder = null;
    }

    //Start recording
    public void startRecord() {
        mRecorder = new MediaRecorder();
        mRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
        mRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
        mRecorder.setOutputFile(FileName);
        mRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
        try {
            mRecorder.prepare();
            mRecorder.start();
        } catch (IOException e) {
            Log.e(LOG_TAG, "prepare() failed ---" + e.getMessage());
        }

    }

    class startPlayListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            if(!startPlayRecordFlag){
                startPlayRecordFlag = true;
                startPlay.setText("pause");
                startRecord.setVisibility(View.INVISIBLE);
                startPlayRecord();
            } else {
                startPlayRecordFlag = false;
                startPlay.setText("start playing");
                startRecord.setVisibility(View.VISIBLE);
                stopPlayRecord();
            }
        }
    }


    public void startPlayRecord() {
        mPlayer = new MediaPlayer();
        try {
            mPlayer.setDataSource(FileName);
            mPlayer.prepare();
            mPlayer.start();

            mPlayer.setOnCompletionListener(mp -> {
                startPlayRecordFlag = false;
                startPlay.setText("start playing");
                startRecord.setVisibility(View.VISIBLE);
                stopPlayRecord();
            });
        } catch (IOException e) {
            Log.e(LOG_TAG, "fail to play");
        }
    }
    public void stopPlayRecord() {
        mPlayer.release();
        mPlayer = null;
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
